/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif

module lpm_counter ( q, eq, 
        data, clock,
        clk_en, cnt_en, updown,
        aset, aclr, aload, aconst,
        sset, sclr, sload, sconst) ;

  parameter lpm_type     = "lpm_counter" ;
  parameter lpm_width    = 1 ;
  parameter lpm_modulus  = 1<<lpm_width ;
  parameter lpm_avalue   = 0 ;
  parameter lpm_svalue   = 0 ;
  parameter lpm_direction  = "UNUSED" ;
  parameter polar_q      = "NORMAL" ;
  parameter polar_data   = "NORMAL" ;
  parameter polar_eq     = "NORMAL" ;
  parameter polar_clock  = "NORMAL" ;
  parameter polar_clk_en = "NORMAL" ;
  parameter polar_cnt_en = "NORMAL" ;
  parameter polar_updown = "NORMAL" ;
  parameter polar_aset   = "NORMAL" ;
  parameter polar_aclr   = "NORMAL" ;
  parameter polar_aload  = "NORMAL" ;
  parameter polar_aconst = "NORMAL" ;
  parameter polar_sset   = "NORMAL" ;
  parameter polar_sclr   = "NORMAL" ;
  parameter polar_sload  = "NORMAL" ;
  parameter polar_sconst = "NORMAL" ;

  output [lpm_width-1:0] q ;
  output [15:0] eq ;
  input  [lpm_width-1:0] data ;
  input  clock, clk_en, cnt_en, updown ;
  input  aset, aclr, aload, aconst ;
  input  sset, sclr, sload, sconst ;

  reg  [lpm_width-1:0] pdata ;
  reg  pclock, pclk_en, pcnt_en, pupdown ;
  reg  paset, paclr, paload, paconst ;
  reg  psset, psclr, psload, psconst ;
  reg  [15:0] tmp_eq ;
  reg  [lpm_width-1:0] tmp_count ;
  reg  [lpm_width-1:0] ONES, HiZ ;
  reg  [lpm_width-1:0] re_start ;
  reg no_enable, clock_enable, count_enable ;
  integer i, up_limit ;
 
//---------------------------------------------------------------//
  function [lpm_width-1:0] NextBin ;
        input [lpm_width-1:0] count ;
    begin 
	  up_limit = (pupdown == 1)?(lpm_modulus - 1):0 ;
	  re_start = (pupdown == 1)?0:(lpm_modulus - 1) ;
	  if(((count >= up_limit) && updown)
		|| ((count == up_limit) && !updown))
		NextBin = re_start ;
	  else
	  	NextBin = (pupdown == 1)?count+1:count-1 ;
    end 
  endfunction

//---------------------------------------------------------------//
//  function [(1<<lpm_width)-1:0] CountDecode ;
//---------------------------------------------------------------//
  function [15:0] CountDecode ;
    input [lpm_width-1:0] count ;
    integer eq_index ;
    begin
	  CountDecode = 0 ;
	  if(count <= 15)
	  begin
		  eq_index = count ;
	  	  CountDecode[eq_index] = 1'b1 ;
	  end
    end
  endfunction

//---------------------------------------------------------------//
  initial
    begin
  	  no_enable = 1'b0 ;
	  clock_enable = 1'b0 ;
	  count_enable  = 1'b0 ;

      for (i=0; i<lpm_width; i=i+1)
		begin
         	ONES[i] = 1'b1 ;
         	HiZ[i] = 1'bz ;
		end
		 
	  // check if module has valid configuration
	  if(lpm_modulus > (1 << lpm_width))
		  $display("Error! lpm_modulus is out of bound.\n");

	  if(((aload !== 1'bz) || (sload !== 1'bz))
	    &&(data === HiZ))
		  $display("Error! If aload or sload is used, data must be used.");

	  if(((aset !== 1'bz) || (aclr !== 1'bz)) &&(aconst !== 1'bz))
		  $display("Error! If aset or aclr is used, aconst must not be used.");

	  if(((sset !== 1'bz) || (sclr !== 1'bz)) &&(sconst !== 1'bz))
		  $display("Error! If sset or sclr is used, sconst must not be used.");
	  
	  if(((aload !== 1'bz) || (sload !== 1'bz)) && (data === HiZ))
		  $display("Error! Data is not used when load pin is used.\n");
	  
	  if((lpm_direction !== "UNUSED") && (updown !== 1'bz))
		  $display("Error! Property lpm_direction and pin updown are used mutually exclusive.\n");

	  if((clk_en !== 1'bz) && (cnt_en !== 1'bz))
		  $display("Error! Pins clk_en and cnt_en are used mutually exclusive.\n");

	  // initialize unconnected pins
	  if((clk_en === 1'bz) && (cnt_en === 1'bz))
		  no_enable = 1'b1 ;
	  else if((clk_en !== 1'bz) && (cnt_en === 1'bz))
		  clock_enable = 1'b1 ;
	  else if((clk_en === 1'bz) && (cnt_en !== 1'bz))
		  count_enable = 1'b1 ;
		  
	  if((updown === 1'bz) 
	  && ((lpm_direction === "UNUSED") || (lpm_direction === "UP")))
		  pupdown = 1'b1;
	  else if (lpm_direction === "DOWN")
		  pupdown = 1'b0;

	  if(aset === 1'bz)
		  paset = 1'b0;

	  if(aclr === 1'bz)
		  paclr = 1'b0;

	  if(aconst === 1'bz)
		  paconst = 1'b0;

	  if(aload === 1'bz)
		  paload = 1'b0;

	  if(sset === 1'bz)
		  psset = 1'b0;

	  if(sclr === 1'bz)
		  psclr = 1'b0;

	  if(sconst === 1'bz)
		  psconst = 1'b0;

	  if(sload === 1'bz)
		  psload = 1'b0;

	  tmp_count = 0 ;
      tmp_eq = 0 ;
	end

  
  always @(aset)
	  paset   <= (polar_aset == "INVERT")?~aset:aset ;

  always @(aclr)
	  paclr   <= (polar_aclr == "INVERT")?~aclr:aclr ;

  always @(aconst)
	  paconst <= (polar_aconst == "INVERT")?~aconst:aconst ;

  always @(aload)
	  paload  <= (polar_aload == "INVERT")?~aload:aload ;

  always @(sset)
	  psset   <= #1 (polar_sset == "INVERT")?~sset:sset ;

  always @(sclr)
	  psclr   <= #1 (polar_sclr == "INVERT")?~sclr:sclr ;

  always @(sconst)
	  psconst <= #1 (polar_sconst == "INVERT")?~sconst:sconst ;

  always @(sload)
	  psload  <= #1 (polar_sload == "INVERT")?~sload:sload ;

  always @(clk_en)
	  pclk_en <= #1 (polar_clk_en == "INVERT")?~clk_en:clk_en ;

  always @(cnt_en)
	  pcnt_en <= #1 (polar_cnt_en == "INVERT")?~cnt_en:cnt_en ;

  always @(clock )
  	  pclock  <= #1 (polar_clock == "INVERT")?~clock:clock ;

  always @(updown)
    begin
	  pupdown <= #1 (polar_updown == "INVERT")?~updown:updown ;
    end

  always @(data )
	  pdata   <= #1 (polar_data == "INVERT")?~data:data ;


  always @(pdata or paclr or paset or paconst or paload)
    begin :asyn_block
      if (paclr)
        begin
          assign tmp_count = 0 ;
        end
      else if (paset)
        begin
          assign tmp_count = ONES ;
        end
      else if (paconst)
        begin
	  		// check if avalue is out of bound
	  		if(lpm_avalue >= (1 << lpm_width))
		  		$display("Error! lpm_avalue is out of bound.\n");
	  		else if(lpm_avalue < 0)
		  		$display("Error! lpm_avalue must be a positive value.\n");
			else
          		assign tmp_count = lpm_avalue ;
        end
      else if (paload)
        begin
          assign tmp_count = pdata ;
        end
	  else
		begin
		  deassign tmp_count ;
		end
	end

  always @(posedge pclock)
    begin :syn_block
	  if(no_enable || (clock_enable && pclk_en) || count_enable )
		begin
	      if (psclr)
			begin :syn_clr
				if(paclr)
					disable syn_clr;
	          	else
				 	tmp_count = 0 ;
			end
	      else if (psset)
			begin :syn_set
				if(paset)
					disable syn_set;
			  	else
					tmp_count = ONES ;
			end
	      else if (psconst)
			begin :syn_const
				if(paconst)
					disable syn_const;
			  	else
	  				// check if svalue is out of bound
	  				if(lpm_svalue >= (1 << lpm_width))
		  				$display("Error! lpm_svalue is out of bound.\n");
	  				else if(lpm_svalue < 0)
		  				$display("Error! lpm_svalue must be a positive value.\n");
					else
						tmp_count = lpm_svalue ;
			end
	      else if (psload)
			begin :syn_load
				if(paload)
					disable syn_load;
			  	else
					tmp_count = pdata ;
			end
	  	  else if(no_enable || pclk_en || cnt_en)
			begin
			  tmp_count = NextBin(tmp_count) ;
	        end
		end
	end //pclock

  assign q =  (polar_q == "INVERT")? ~tmp_count: tmp_count ;
  assign eq =  (polar_eq == "INVERT")? ~CountDecode(tmp_count):CountDecode(tmp_count) ;

 endmodule // lpm_counter
`ifdef SYNTH
`else
`endcelldefine
`endif

